/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.network.client;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundSource;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.common.config.Config;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.network.ShopNetwork;

public class SendBuyShopEntryC2S
extends BaseC2SMessage {
    private final UUID tabUUID;
    private final UUID entryUUID;
    private final int count;

    public SendBuyShopEntryC2S(UUID tabUUID, UUID entryUUID, int count) {
        this.tabUUID = tabUUID;
        this.entryUUID = entryUUID;
        this.count = count;
    }

    public SendBuyShopEntryC2S(FriendlyByteBuf buf) {
        this.tabUUID = buf.m_130259_();
        this.entryUUID = buf.m_130259_();
        this.count = buf.readInt();
    }

    public MessageType getType() {
        return ShopNetwork.SEND_BUY_ENTRY;
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130077_(this.tabUUID);
        friendlyByteBuf.m_130077_(this.entryUUID);
        friendlyByteBuf.writeInt(this.count);
    }

    public void handle(NetworkManager.PacketContext packetContext) {
        AbstractShopEntry entry = ShopBase.SERVER.getShopTab(this.tabUUID).getShopEntry(this.entryUUID);
        if (entry.isSell) {
            try {
                entry.getEntryType().sell(packetContext.getPlayer(), this.count, entry);
            }
            catch (Exception e) {
                SDMShopRework.printStackTrace("", e);
            }
        } else {
            try {
                entry.getEntryType().buy(packetContext.getPlayer(), this.count, entry);
            }
            catch (Exception e) {
                SDMShopRework.printStackTrace("", e);
            }
        }
        if (((Boolean)Config.SEND_NOTIFY.get()).booleanValue()) {
            entry.getEntryType().sendNotifiedMessage(packetContext.getPlayer());
        }
        packetContext.getPlayer().m_6330_(SDMShopRework.BUY_SOUND, SoundSource.VOICE, 1.0f, 1.0f);
    }
}

